<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group_Battles extends Model
{
    use HasFactory;

    protected $table = 'tbl_group_battles';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'room_code' => 'string',
        'name' => 'string',
        'created_user_id' => 'integer',
        'question_ids' => 'string',
        'total_questions' => 'integer',
        'joining_coin' => 'integer',
        'winning_coin' => 'integer',
        'status' => 'integer',
    ];

    public function created_user()
    {
        return $this->belongsTo(User::class, 'created_user_id');
    }
}
